#ifndef __ECAT_DIAG_H
#define __ECAT_DIAG_H

/////////////////////////////////////////////////////////////////////////////////////
// EtherCAT DPM Stack Diagnostic Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_DIAG_E_ECAT_DPM_WATCHDOG_TRIGGERED
//
// MessageText:
//
//  DPM Watchdog triggered.
//
#define TLR_DIAG_E_ECAT_DPM_WATCHDOG_TRIGGERED ((TLR_RESULT)0xC04C0001L)

/////////////////////////////////////////////////////////////////////////////////////
// EtherCAT Base Stack Diagnostic Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_DIAG_E_ECAT_BASE_LOST_PCK_ALARM
//
// MessageText:
//
//  Mailbox Packet Lost.
//
#define TLR_DIAG_E_ECAT_BASE_LOST_PCK_ALARM ((TLR_RESULT)0xC0200001L)

//
// MessageId: TLR_DIAG_W_ECAT_BASE_MAILBOX_POOL_EMPTY
//
// MessageText:
//
//  Mailbox stopped due to empty packet pool.
//
#define TLR_DIAG_W_ECAT_BASE_MAILBOX_POOL_EMPTY ((TLR_RESULT)0x80200002L)

//
// MessageId: TLR_DIAG_E_ECAT_BASE_INVALID_STARTUP_PARAMETER
//
// MessageText:
//
//  Invalid Startup Parameter.
//
#define TLR_DIAG_E_ECAT_BASE_INVALID_STARTUP_PARAMETER ((TLR_RESULT)0xC0200002L)

//
// MessageId: TLR_DIAG_E_ECAT_BASE_COULD_NOT_CREATE_STACK_DATA
//
// MessageText:
//
//  Could not create stack data storage.
//
#define TLR_DIAG_E_ECAT_BASE_COULD_NOT_CREATE_STACK_DATA ((TLR_RESULT)0xC0200003L)

//
// MessageId: TLR_DIAG_E_ECAT_BASE_DYNAMIC_DATA_INVALID
//
// MessageText:
//
//  Dynamic Data invalid.
//
#define TLR_DIAG_E_ECAT_BASE_DYNAMIC_DATA_INVALID ((TLR_RESULT)0xC0200004L)

//
// MessageId: TLR_DIAG_E_ECAT_BASE_URX0_OVERFLOW
//
// MessageText:
//
//  Urx0 overflow.
//
#define TLR_DIAG_E_ECAT_BASE_URX0_OVERFLOW ((TLR_RESULT)0xC0200005L)

//
// MessageId: TLR_DIAG_E_ECAT_BASE_UTX0_UNDERFLOW
//
// MessageText:
//
//  Utx0 underflow.
//
#define TLR_DIAG_E_ECAT_BASE_UTX0_UNDERFLOW ((TLR_RESULT)0xC0200006L)

//
// MessageId: TLR_DIAG_E_ECAT_BASE_URX1_OVERFLOW
//
// MessageText:
//
//  Urx1 overflow.
//
#define TLR_DIAG_E_ECAT_BASE_URX1_OVERFLOW ((TLR_RESULT)0xC0200007L)

//
// MessageId: TLR_DIAG_E_ECAT_BASE_UTX1_UNDERFLOW
//
// MessageText:
//
//  Utx1 underflow.
//
#define TLR_DIAG_E_ECAT_BASE_UTX1_UNDERFLOW ((TLR_RESULT)0xC0200008L)

//
// MessageId: TLR_DIAG_E_ECAT_BASE_ESM_QUEUE_IDENTIFY_FAILED
//
// MessageText:
//
//  Queue identification of EcatEsm-task queue failed.
//
#define TLR_DIAG_E_ECAT_BASE_ESM_QUEUE_IDENTIFY_FAILED ((TLR_RESULT)0xC0200009L)

//
// MessageId: TLR_DIAG_E_ECAT_BASE_ESM_PACKET_POOL_IDENTIFY_FAILED
//
// MessageText:
//
//  Packet pool identification of EcatEsm-task pool failed.
//
#define TLR_DIAG_E_ECAT_BASE_ESM_PACKET_POOL_IDENTIFY_FAILED ((TLR_RESULT)0xC020000AL)

//
// MessageId: TLR_DIAG_E_ECAT_BASE_LOCK_CREATION_FAILED
//
// MessageText:
//
//  Creation of lock failed.
//
#define TLR_DIAG_E_ECAT_BASE_LOCK_CREATION_FAILED ((TLR_RESULT)0xC020000BL)

//
// MessageId: TLR_DIAG_E_ECAT_BASE_INVALID_ESM_DBM_DATA
//
// MessageText:
//
//  Invalid ESM DBM data.
//
#define TLR_DIAG_E_ECAT_BASE_INVALID_ESM_DBM_DATA ((TLR_RESULT)0xC020000CL)

//
// MessageId: TLR_DIAG_E_ECAT_BASE_INVALID_MBX_DBM_DATA
//
// MessageText:
//
//  Invalid MBX DBM data.
//
#define TLR_DIAG_E_ECAT_BASE_INVALID_MBX_DBM_DATA ((TLR_RESULT)0xC020000DL)

//
// MessageId: TLR_DIAG_E_ECAT_BASE_TIMER_CREATE_FAILED
//
// MessageText:
//
//  Creation of timer failed.
//
#define TLR_DIAG_E_ECAT_BASE_TIMER_CREATE_FAILED ((TLR_RESULT)0xC020000EL)

//
// MessageId: TLR_DIAG_E_ECAT_BASE_PACKET_GET_FAILED
//
// MessageText:
//
//  Retrieving a packet from pool failed.
//
#define TLR_DIAG_E_ECAT_BASE_PACKET_GET_FAILED ((TLR_RESULT)0xC020000FL)

//
// MessageId: TLR_DIAG_E_ECAT_BASE_MBX_QUEUE_IDENTIFY_FAILED
//
// MessageText:
//
//  Queue identification of EcatMbx-task queue failed.
//
#define TLR_DIAG_E_ECAT_BASE_MBX_QUEUE_IDENTIFY_FAILED ((TLR_RESULT)0xC0200010L)

//
// MessageId: TLR_DIAG_E_ECAT_BASE_MUTEX_CREATION_FAILED
//
// MessageText:
//
//  Creation of mutex failed.
//
#define TLR_DIAG_E_ECAT_BASE_MUTEX_CREATION_FAILED ((TLR_RESULT)0xC0200011L)

//
// MessageId: TLR_DIAG_S_ECAT_BASE_STATE_INIT
//
// MessageText:
//
//  Slave is currently in state INIT.
//
#define TLR_DIAG_S_ECAT_BASE_STATE_INIT  ((TLR_RESULT)0x00200012L)

//
// MessageId: TLR_DIAG_S_ECAT_BASE_STATE_PREOP
//
// MessageText:
//
//  Slave is currently in state PREOP.
//
#define TLR_DIAG_S_ECAT_BASE_STATE_PREOP ((TLR_RESULT)0x00200013L)

//
// MessageId: TLR_DIAG_S_ECAT_BASE_STATE_SAFEOP
//
// MessageText:
//
//  Slave is currently in state SAFEOP.
//
#define TLR_DIAG_S_ECAT_BASE_STATE_SAFEOP ((TLR_RESULT)0x00200014L)

//
// MessageId: TLR_DIAG_S_ECAT_BASE_STATE_OP
//
// MessageText:
//
//  Slave is currently in state OPERATIONAL.
//
#define TLR_DIAG_S_ECAT_BASE_STATE_OP    ((TLR_RESULT)0x00200015L)

//
// MessageId: TLR_DIAG_W_ECAT_BASE_STATE_ERR_INIT
//
// MessageText:
//
//  Slave is currently in state ERR INIT.
//
#define TLR_DIAG_W_ECAT_BASE_STATE_ERR_INIT ((TLR_RESULT)0x80200012L)

//
// MessageId: TLR_DIAG_W_ECAT_BASE_STATE_ERR_PREOP
//
// MessageText:
//
//  Slave is currently in state ERR PREOP.
//
#define TLR_DIAG_W_ECAT_BASE_STATE_ERR_PREOP ((TLR_RESULT)0x80200013L)

//
// MessageId: TLR_DIAG_W_ECAT_BASE_STATE_ERR_SAFEOP
//
// MessageText:
//
//  Slave is currently in state ERR SAFEOP.
//
#define TLR_DIAG_W_ECAT_BASE_STATE_ERR_SAFEOP ((TLR_RESULT)0x80200014L)

//
// MessageId: TLR_DIAG_W_ECAT_BASE_STATE_ERR_OP
//
// MessageText:
//
//  Slave is currently in state ERR OP.
//
#define TLR_DIAG_W_ECAT_BASE_STATE_ERR_OP ((TLR_RESULT)0x80200015L)

//
// MessageId: TLR_DIAG_S_ECAT_BASE_STATE_BOOTING
//
// MessageText:
//
//  Slave is currently booting.
//
#define TLR_DIAG_S_ECAT_BASE_STATE_BOOTING ((TLR_RESULT)0x00200016L)

/////////////////////////////////////////////////////////////////////////////////////
// EtherCAT CoE Stack Diagnostic Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_DIAG_W_ECAT_COE_NOT_INITIALIZED
//
// MessageText:
//
//  CoE stack not initialized.
//
#define TLR_DIAG_W_ECAT_COE_NOT_INITIALIZED ((TLR_RESULT)0x80210001L)

//
// MessageId: TLR_DIAG_E_ECAT_COE_PDO_STAGE2_FAILED
//
// MessageText:
//
//  PDO configuration could not be loaded.
//
#define TLR_DIAG_E_ECAT_COE_PDO_STAGE2_FAILED ((TLR_RESULT)0xC0210002L)

//
// MessageId: TLR_DIAG_E_ECAT_COE_INVALID_STARTUP_PARAMETER
//
// MessageText:
//
//  Invalid Startup Parameter.
//
#define TLR_DIAG_E_ECAT_COE_INVALID_STARTUP_PARAMETER ((TLR_RESULT)0xC0210003L)

//
// MessageId: TLR_DIAG_E_ECAT_COE_COULD_NOT_CREATE_STACK_DATA
//
// MessageText:
//
//  Could not create stack data storage.
//
#define TLR_DIAG_E_ECAT_COE_COULD_NOT_CREATE_STACK_DATA ((TLR_RESULT)0xC0210004L)

//
// MessageId: TLR_DIAG_E_ECAT_COE_COULD_NOT_CREATE_OBJECT_DICTIONARY
//
// MessageText:
//
//  Could not create object dictionary.
//
#define TLR_DIAG_E_ECAT_COE_COULD_NOT_CREATE_OBJECT_DICTIONARY ((TLR_RESULT)0xC0210005L)

//
// MessageId: TLR_DIAG_E_ECAT_COE_MBX_QUEUE_IDENTIFY_FAILED
//
// MessageText:
//
//  Queue identification of EcatMbx-task queue failed.
//
#define TLR_DIAG_E_ECAT_COE_MBX_QUEUE_IDENTIFY_FAILED ((TLR_RESULT)0xC0210006L)

//
// MessageId: TLR_DIAG_E_ECAT_COE_COE_QUEUE_IDENTIFY_FAILED
//
// MessageText:
//
//  Queue identification of EcatCoE-task queue failed.
//
#define TLR_DIAG_E_ECAT_COE_COE_QUEUE_IDENTIFY_FAILED ((TLR_RESULT)0xC0210007L)

//
// MessageId: TLR_DIAG_E_ECAT_COE_ESM_QUEUE_IDENTIFY_FAILED
//
// MessageText:
//
//  Queue identification of EcatEsm-task queue failed.
//
#define TLR_DIAG_E_ECAT_COE_ESM_QUEUE_IDENTIFY_FAILED ((TLR_RESULT)0xC0210008L)

//
// MessageId: TLR_DIAG_E_ECAT_COE_PACKET_GET_FAILED
//
// MessageText:
//
//  Retrieving a packet from pool failed.
//
#define TLR_DIAG_E_ECAT_COE_PACKET_GET_FAILED ((TLR_RESULT)0xC021000AL)

//
// MessageId: TLR_DIAG_E_ECAT_COE_TIMER_CREATE_FAILED
//
// MessageText:
//
//  Creation of a timer failed.
//
#define TLR_DIAG_E_ECAT_COE_TIMER_CREATE_FAILED ((TLR_RESULT)0xC021000BL)

//
// MessageId: TLR_DIAG_E_ECAT_COE_MUTEX_CREATION_FAILED
//
// MessageText:
//
//  Creation of mutex failed.
//
#define TLR_DIAG_E_ECAT_COE_MUTEX_CREATION_FAILED ((TLR_RESULT)0xC021000CL)

//
// MessageId: TLR_DIAG_E_ECAT_COE_SDO_QUEUE_IDENTIFY_FAILED
//
// MessageText:
//
//  Queue identification of EcatSdo-task queue failed.
//
#define TLR_DIAG_E_ECAT_COE_SDO_QUEUE_IDENTIFY_FAILED ((TLR_RESULT)0xC021000DL)

//
// MessageId: TLR_DIAG_E_ECAT_COE_PDO_DBM_DATA_INVALID
//
// MessageText:
//
//  Invalid EcatPdo task DBM data.
//
#define TLR_DIAG_E_ECAT_COE_PDO_DBM_DATA_INVALID ((TLR_RESULT)0xC021000EL)

//
// MessageId: TLR_DIAG_E_ECAT_COE_PDO_QUEUE_IDENTIFY_FAILED
//
// MessageText:
//
//  Queue identification of EcatPdo-task queue failed.
//
#define TLR_DIAG_E_ECAT_COE_PDO_QUEUE_IDENTIFY_FAILED ((TLR_RESULT)0xC0210010L)

/////////////////////////////////////////////////////////////////////////////////////
// EtherCAT SoE Stack Diagnostic Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_DIAG_W_ECAT_SOE_NOT_INITIALIZED
//
// MessageText:
//
//  SoE stack not initialized.
//
#define TLR_DIAG_W_ECAT_SOE_NOT_INITIALIZED ((TLR_RESULT)0x80220001L)

//
// MessageId: TLR_DIAG_E_ECAT_SOE_INVALID_STARTUP_PARAMETER
//
// MessageText:
//
//  Invalid Startup Parameter.
//
#define TLR_DIAG_E_ECAT_SOE_INVALID_STARTUP_PARAMETER ((TLR_RESULT)0xC0220002L)

//
// MessageId: TLR_DIAG_E_ECAT_SOE_COULD_NOT_CREATE_STACK_DATA
//
// MessageText:
//
//  Could not create stack data storage.
//
#define TLR_DIAG_E_ECAT_SOE_COULD_NOT_CREATE_STACK_DATA ((TLR_RESULT)0xC0220003L)

//
// MessageId: TLR_DIAG_E_ECAT_SOE_MBX_QUEUE_IDENTIFY_FAILED
//
// MessageText:
//
//  Queue identification of EcatMbx task queue failed.
//
#define TLR_DIAG_E_ECAT_SOE_MBX_QUEUE_IDENTIFY_FAILED ((TLR_RESULT)0xC0220004L)

//
// MessageId: TLR_DIAG_E_ECAT_SOE_ESM_QUEUE_IDENTIFY_FAILED
//
// MessageText:
//
//  Queue identification of EcatEsm task queue failed.
//
#define TLR_DIAG_E_ECAT_SOE_ESM_QUEUE_IDENTIFY_FAILED ((TLR_RESULT)0xC0220005L)

/////////////////////////////////////////////////////////////////////////////////////
// EtherCAT EoE Stack Diagnostic Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_DIAG_W_ECAT_EOE_NOT_INITIALIZED
//
// MessageText:
//
//  EoE stack not initialized.
//
#define TLR_DIAG_W_ECAT_EOE_NOT_INITIALIZED ((TLR_RESULT)0x80230001L)

//
// MessageId: TLR_DIAG_E_ECAT_EOE_INVALID_STARTUP_PARAMETER
//
// MessageText:
//
//  Invalid Startup Parameter.
//
#define TLR_DIAG_E_ECAT_EOE_INVALID_STARTUP_PARAMETER ((TLR_RESULT)0xC0230001L)

//
// MessageId: TLR_DIAG_E_ECAT_EOE_COULD_NOT_CREATE_STACK_DATA
//
// MessageText:
//
//  Could not create stack data storage.
//
#define TLR_DIAG_E_ECAT_EOE_COULD_NOT_CREATE_STACK_DATA ((TLR_RESULT)0xC0230002L)

//
// MessageId: TLR_DIAG_E_ECAT_EOE_MUTEX_CREATE_FAILED
//
// MessageText:
//
//  Creation of mutex failed.
//
#define TLR_DIAG_E_ECAT_EOE_MUTEX_CREATE_FAILED ((TLR_RESULT)0xC0230003L)

//
// MessageId: TLR_DIAG_E_ECAT_EOE_VSWITCH_CREATE_FAILED
//
// MessageText:
//
//  Creation of virtual switch failed.
//
#define TLR_DIAG_E_ECAT_EOE_VSWITCH_CREATE_FAILED ((TLR_RESULT)0xC0230004L)

//
// MessageId: TLR_DIAG_E_ECAT_EOE_ESM_QUEUE_IDENTIFY_FAILED
//
// MessageText:
//
//  Queue identification of EcatEsm task queue failed.
//
#define TLR_DIAG_E_ECAT_EOE_ESM_QUEUE_IDENTIFY_FAILED ((TLR_RESULT)0xC0230005L)

//
// MessageId: TLR_DIAG_E_ECAT_EOE_MBX_QUEUE_IDENTIFY_FAILED
//
// MessageText:
//
//  Queue identification of EcatMbx task queue failed.
//
#define TLR_DIAG_E_ECAT_EOE_MBX_QUEUE_IDENTIFY_FAILED ((TLR_RESULT)0xC0230006L)

//
// MessageId: TLR_DIAG_E_ECAT_EOE_INVALID_DBM_DATA
//
// MessageText:
//
//  Invalid EcatEoE task DBM data.
//
#define TLR_DIAG_E_ECAT_EOE_INVALID_DBM_DATA ((TLR_RESULT)0xC0230007L)

//
// MessageId: TLR_DIAG_E_ECAT_EOE_CONFIG_SETUP_FAILED
//
// MessageText:
//
//  Setup of configuration access failed.
//
#define TLR_DIAG_E_ECAT_EOE_CONFIG_SETUP_FAILED ((TLR_RESULT)0xC0230008L)

//
// MessageId: TLR_DIAG_E_ECAT_EOE_VSWITCH_PORT_CREATE_FAILED
//
// MessageText:
//
//  Creation of Virtual Switch port failed.
//
#define TLR_DIAG_E_ECAT_EOE_VSWITCH_PORT_CREATE_FAILED ((TLR_RESULT)0xC0230009L)

//
// MessageId: TLR_DIAG_E_ECAT_EOE_PACKET_GET_FAILED
//
// MessageText:
//
//  Retrieving a packet from pool failed.
//
#define TLR_DIAG_E_ECAT_EOE_PACKET_GET_FAILED ((TLR_RESULT)0xC023000AL)

//
// MessageId: TLR_DIAG_E_ECAT_EOE_TIMER_CREATE_FAILED
//
// MessageText:
//
//  Creation of a timer failed.
//
#define TLR_DIAG_E_ECAT_EOE_TIMER_CREATE_FAILED ((TLR_RESULT)0xC023000BL)

//
// MessageId: TLR_DIAG_E_ECAT_EOE_TCPTASK_QUEUE_IDENTIFY_FAILED
//
// MessageText:
//
//  Queue identification of TCP-task failed.
//
#define TLR_DIAG_E_ECAT_EOE_TCPTASK_QUEUE_IDENTIFY_FAILED ((TLR_RESULT)0xC023000CL)

/////////////////////////////////////////////////////////////////////////////////////
// EtherCAT FoE Stack Diagnostic Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_DIAG_W_ECAT_FOE_NOT_INITIALIZED
//
// MessageText:
//
//  FoE stack not initialized.
//
#define TLR_DIAG_W_ECAT_FOE_NOT_INITIALIZED ((TLR_RESULT)0x80240001L)

//
// MessageId: TLR_DIAG_E_ECAT_FOE_INVALID_STARTUP_PARAMETER
//
// MessageText:
//
//  Invalid Startup Parameter.
//
#define TLR_DIAG_E_ECAT_FOE_INVALID_STARTUP_PARAMETER ((TLR_RESULT)0xC0240001L)

//
// MessageId: TLR_DIAG_E_ECAT_FOE_COULD_NOT_CREATE_STACK_DATA
//
// MessageText:
//
//  Could not create stack data storage.
//
#define TLR_DIAG_E_ECAT_FOE_COULD_NOT_CREATE_STACK_DATA ((TLR_RESULT)0xC0240002L)

//
// MessageId: TLR_DIAG_E_ECAT_FOE_MBX_QUEUE_IDENTIFY_FAILED
//
// MessageText:
//
//  Queue identification of EcatMbx task queue failed.
//
#define TLR_DIAG_E_ECAT_FOE_MBX_QUEUE_IDENTIFY_FAILED ((TLR_RESULT)0xC0240003L)

//
// MessageId: TLR_DIAG_E_ECAT_FOE_ESM_QUEUE_IDENTIFY_FAILED
//
// MessageText:
//
//  Queue identification of EcatEsm task queue failed.
//
#define TLR_DIAG_E_ECAT_FOE_ESM_QUEUE_IDENTIFY_FAILED ((TLR_RESULT)0xC0240004L)

//
// MessageId: TLR_DIAG_E_ECAT_FOE_DBM_DATA_INVALID
//
// MessageText:
//
//  Invalid EcatFoE task DBM data.
//
#define TLR_DIAG_E_ECAT_FOE_DBM_DATA_INVALID ((TLR_RESULT)0xC0240005L)

//
// MessageId: TLR_DIAG_E_ECAT_FOE_DEF_HANDLER_INIT_FAILED
//
// MessageText:
//
//  Initialization of default FoE handler failed.
//
#define TLR_DIAG_E_ECAT_FOE_DEF_HANDLER_INIT_FAILED ((TLR_RESULT)0xC0240006L)

//
// MessageId: TLR_DIAG_E_ECAT_FOE_TIMER_CREATE_FAILED
//
// MessageText:
//
//  Creation of timer failed.
//
#define TLR_DIAG_E_ECAT_FOE_TIMER_CREATE_FAILED ((TLR_RESULT)0xC0240007L)

/////////////////////////////////////////////////////////////////////////////////////
// EtherCAT AoE Stack Diagnostic Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_DIAG_W_ECAT_AOE_NOT_INITIALIZED
//
// MessageText:
//
//  AoE stack not initialized.
//
#define TLR_DIAG_W_ECAT_AOE_NOT_INITIALIZED ((TLR_RESULT)0x80250001L)

//
// MessageId: TLR_DIAG_E_ECAT_AOE_INVALID_STARTUP_PARAMETER
//
// MessageText:
//
//  Invalid Startup Parameter.
//
#define TLR_DIAG_E_ECAT_AOE_INVALID_STARTUP_PARAMETER ((TLR_RESULT)0xC0250001L)

//
// MessageId: TLR_DIAG_E_ECAT_AOE_COULD_NOT_CREATE_STACK_DATA
//
// MessageText:
//
//  Could not create stack data storage.
//
#define TLR_DIAG_E_ECAT_AOE_COULD_NOT_CREATE_STACK_DATA ((TLR_RESULT)0xC0250002L)

/////////////////////////////////////////////////////////////////////////////////////
// EtherCAT VoE Stack Diagnostic Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_DIAG_W_ECAT_VOE_NOT_INITIALIZED
//
// MessageText:
//
//  VoE stack not initialized.
//
#define TLR_DIAG_W_ECAT_VOE_NOT_INITIALIZED ((TLR_RESULT)0x80260001L)

//
// MessageId: TLR_DIAG_E_ECAT_VOE_INVALID_STARTUP_PARAMETER
//
// MessageText:
//
//  Invalid Startup Parameter.
//
#define TLR_DIAG_E_ECAT_VOE_INVALID_STARTUP_PARAMETER ((TLR_RESULT)0xC0260001L)

//
// MessageId: TLR_DIAG_E_ECAT_VOE_COULD_NOT_CREATE_STACK_DATA
//
// MessageText:
//
//  Could not create stack data storage.
//
#define TLR_DIAG_E_ECAT_VOE_COULD_NOT_CREATE_STACK_DATA ((TLR_RESULT)0xC0260002L)

//
// MessageId: TLR_DIAG_E_ECAT_VOE_MBX_QUEUE_IDENTIFY_FAILED
//
// MessageText:
//
//  Queue identification of EcatMbx-task queue failed.
//
#define TLR_DIAG_E_ECAT_VOE_MBX_QUEUE_IDENTIFY_FAILED ((TLR_RESULT)0xC0260003L)

//
// MessageId: TLR_DIAG_E_ECAT_VOE_ESM_QUEUE_IDENTIFY_FAILED
//
// MessageText:
//
//  Queue identification of EcatEsm-task queue failed.
//
#define TLR_DIAG_E_ECAT_VOE_ESM_QUEUE_IDENTIFY_FAILED ((TLR_RESULT)0xC0260004L)

//
// MessageId: TLR_DIAG_E_ECAT_VOE_ESM_PACKET_SEND_FAILED
//
// MessageText:
//
//  Sending a packet to the EcatEsm-task failed.
//
#define TLR_DIAG_E_ECAT_VOE_ESM_PACKET_SEND_FAILED ((TLR_RESULT)0xC0260005L)

//
// MessageId: TLR_DIAG_E_ECAT_VOE_MBX_PACKET_SEND_FAILED
//
// MessageText:
//
//  Sending a packet to the EcatMbx-task failed.
//
#define TLR_DIAG_E_ECAT_VOE_MBX_PACKET_SEND_FAILED ((TLR_RESULT)0xC0260006L)




#endif  //__ECAT_DIAG_H

